///////////////////////////////////////////////////////////////////////////////
//
// IAR ANSI C/C++ Compiler V7.40.2.8542/W32 for ARM       07/Jul/2015  10:01:32
// Copyright 1999-2015 IAR Systems AB.
//
//    Cpu mode     =  thumb
//    Endian       =  little
//    Source file  =  
//        C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\TPM\Timer.c
//    Command line =  
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\TPM\Timer.c" -D IAR -D gFreqBand_902__928MHz_d -D
//        MKW01_EU --preprocess
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\Debug\List\" -lC
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\Debug\List\" -lB
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\Debug\List\" --diag_suppress Pe188,Pa084,Pe186,Pa082 -o
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\Debug\Obj\" --no_cse --no_unroll --no_inline --no_code_motion
//        --no_tbaa --no_clustering --no_scheduling --debug --endian=little
//        --cpu=Cortex-M0+ -e --fpu=None --dlib_config "C:\Program Files
//        (x86)\IAR Systems\Embedded Workbench
//        7.2\arm\INC\c\DLib_Config_Normal.h" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Generic\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Generic\Interface\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Interface\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Linker\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\Common\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\Common\FunctionLib\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\Common\Sys\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\Common\Utilities\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\Keyboard\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\LED\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\MCG\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\Radio\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\TPM\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\Uart\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\WDOG\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\PLM\Source\Common\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\SMAC\Source\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\SMAC\Interface\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\SMAC\Generic\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\SMAC\PHY\" -I "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple
//        Range Demo\SMAC\PHY\Interface\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\SMAC\PHY\Radio\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\Application\Source\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\Application\Configure\" -I
//        "C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\Application\Interface\" -On --use_c++_inline
//    List file    =  
//        C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range
//        Demo\Debug\List\Timer.s
//
///////////////////////////////////////////////////////////////////////////////

        #define SHT_PROGBITS 0x1

        EXTERN IntDisableAll
        EXTERN IntRestoreAll
        EXTERN NVIC_EnableIRQ
        EXTERN NVIC_SetPriority

        PUBLIC TMR_AllocateTimer
        PUBLIC TMR_AreAllTimersOff
        PUBLIC TMR_EnableTimer
        PUBLIC TMR_FreeTimer
        PUBLIC TMR_Init
        PUBLIC TMR_InterruptHandler
        PUBLIC TMR_IsTimerActive
        PUBLIC TMR_NotifyClkChanged
        PUBLIC TMR_StartIntervalTimer
        PUBLIC TMR_StartMinuteTimer
        PUBLIC TMR_StartSecondTimer
        PUBLIC TMR_StartSingleShotTimer
        PUBLIC TMR_StartTimer
        PUBLIC TMR_StopTimer
        PUBLIC TMR_Task

// C:\Users\b47255\Desktop\AN5070SW\AN5070SW\Simple Range Demo\PLM\Source\TPM\Timer.c
//    1 /******************************************************************************
//    2  * Source file for Timer driver.
//    3  * 
//    4  * Freescale Semiconductor Inc.
//    5  * (c) Copyright 2004-2012 Freescale Semiconductor, Inc.
//    6  * ALL RIGHTS RESERVED.
//    7  *
//    8 *******************************************************************************
//    9  *
//   10  * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
//   11  * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
//   12  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
//   13  * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//   14  * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//   15  * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
//   16  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//   17  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//   18  * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
//   19  * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
//   20  * THE POSSIBILITY OF SUCH DAMAGE.
//   21  *
//   22 ***************************************************************************//*!
//   23 ******************************************************************************/
//   24 
//   25 /******************************************************************************
//   26 *******************************************************************************
//   27 * Includes
//   28 *******************************************************************************
//   29 ******************************************************************************/
//   30 
//   31 #if defined(CW) 
//   32 #include "derivative.h"
//   33 #elif defined(IAR)
//   34 #include "PortConfig.h"
//   35 #else 
//   36 #error "No valid development tool defined"
//   37 #endif
//   38 #include "Timer.h"
//   39 #include "Interrupt.h"
//   40 
//   41 
//   42 /******************************************************************************
//   43 *******************************************************************************
//   44 * Private memory declarations
//   45 *******************************************************************************
//   46 ******************************************************************************/
//   47 
//   48 /******************************************************************************
//   49  * NAME: previousTimeInTicks
//   50  * DESCRIPTION: The previous time in ticks when the counter register was read
//   51  * VALUES: 0..65535
//   52  *****************************************************************************/

        SECTION `.bss`:DATA:REORDER:NOROOT(1)
//   53 static tmrTimerTicks16_t previousTimeInTicks;
previousTimeInTicks:
        DS8 2
//   54 
//   55 /******************************************************************************
//   56  * NAME: mMaxToCountDown_c
//   57  * DESCRIPTION:  Count to maximum (0xffff - 2*4ms(in ticks)), to be sure that 
//   58  * the currentTimeInTicks will never roll over previousTimeInTicks in the 
//   59  * TMR_Task(); A task have to be executed at most in 4ms.
//   60  * VALUES: 0..65535
//   61  *****************************************************************************/

        SECTION `.bss`:DATA:REORDER:NOROOT(1)
//   62 static uint16_t mMaxToCountDown_c; 
mMaxToCountDown_c:
        DS8 2
//   63 
//   64 /******************************************************************************
//   65  * NAME: mTicksFor4ms
//   66  * DESCRIPTION:  Ticks for 4ms. The TMR_Task()event will not be issued faster than 4ms
//   67  * VALUES: uint32_t range
//   68  *****************************************************************************/

        SECTION `.bss`:DATA:REORDER:NOROOT(2)
//   69 static uint32_t mTicksFor4ms;
mTicksFor4ms:
        DS8 4
//   70 
//   71 /******************************************************************************
//   72  * NAME: mClkSourceKhz
//   73  * DESCRIPTION:  The source clock in Khz
//   74  * VALUES: see definition
//   75  *****************************************************************************/

        SECTION `.data`:DATA:REORDER:NOROOT(2)
//   76 static uint32_t mClkSourceKhz = (uint32_t)(gTmrSourceClkKHz_c);
mClkSourceKhz:
        DATA
        DC32 24000
//   77 
//   78 /******************************************************************************
//   79  * NAME: maTmrTimerTable
//   80  * DESCRIPTION:  Main timer table. All allocated timers are stored here.
//   81  *               A timer's ID is it's index in this table.
//   82  * VALUES: see definition
//   83  *****************************************************************************/

        SECTION `.bss`:DATA:REORDER:NOROOT(2)
//   84 static tmrTimerTableEntry_t maTmrTimerTable[gTmrTotalTimers_c];
maTmrTimerTable:
        DS8 36
//   85 
//   86 /******************************************************************************
//   87  * NAME: maTmrTimerStatusTable
//   88  * DESCRIPTION: timer status stable. Making the single-byte-per-timer status
//   89  *              table a separate array saves a bit of code space.
//   90  *              If an entry is == 0, the timer is not allocated.
//   91  * VALUES: see definition
//   92  *****************************************************************************/

        SECTION `.bss`:DATA:REORDER:NOROOT(2)
//   93 static tmrStatus_t maTmrTimerStatusTable[gTmrTotalTimers_c];
maTmrTimerStatusTable:
        DS8 4
//   94 
//   95 /******************************************************************************
//   96  * NAME: numberOfActiveTimers
//   97  * DESCRIPTION: Number of Active timers (without low power capability)
//   98  *              the MCU can not enter low power if numberOfActiveTimers!=0
//   99  * VALUES: 0..255
//  100  *****************************************************************************/

        SECTION `.bss`:DATA:REORDER:NOROOT(0)
//  101 static uint8_t numberOfActiveTimers = 0;
numberOfActiveTimers:
        DS8 1
//  102 
//  103 #define IncrementActiveTimerNumber(type)  ++numberOfActiveTimers                                   
//  104 #define DecrementActiveTimerNumber(type)  --numberOfActiveTimers 
//  105                                           
//  106 
//  107 /******************************************************************************
//  108  * NAME: timerHardwareIsRunning
//  109  * DESCRIPTION: Flag if the hardware timer is running or not
//  110  * VALUES: TRUE/FALSE
//  111  *****************************************************************************/

        SECTION `.bss`:DATA:REORDER:NOROOT(0)
//  112 static bool_t timerHardwareIsRunning = FALSE;
timerHardwareIsRunning:
        DS8 1
//  113 
//  114 /******************************************************************************
//  115 *******************************************************************************
//  116 * Private Prototypes
//  117 *******************************************************************************
//  118 ******************************************************************************/
//  119 
//  120 /******************************************************************************
//  121  * NAME: TMR_GetTimerStatus
//  122  * DESCRIPTION: RETURNs the timer status
//  123  * PARAMETERS:  IN: timerID - the timer ID
//  124  * RETURN: see definition of tmrStatus_t
//  125  * NOTES: none
//  126  *****************************************************************************/
//  127 static tmrStatus_t TMR_GetTimerStatus 
//  128 ( 
//  129     tmrTimerID_t timerID 
//  130 );
//  131 
//  132 /******************************************************************************
//  133  * NAME: TMR_SetTimerStatus
//  134  * DESCRIPTION: Set the timer status
//  135  * PARAMETERS:  IN: timerID - the timer ID
//  136  * 			   IN: status - the status of the timer
//  137  * RETURN: None
//  138  * NOTES: none
//  139  *****************************************************************************/
//  140 static void TMR_SetTimerStatus
//  141 ( 
//  142     tmrTimerID_t timerID,
//  143     tmrStatus_t status
//  144 );
//  145 
//  146 /******************************************************************************
//  147  * NAME: TMR_GetTimerType
//  148  * DESCRIPTION: RETURNs the timer type
//  149  * PARAMETERS:  IN: timerID - the timer ID
//  150  * RETURN: see definition of tmrTimerType_t
//  151  * NOTES: none
//  152  *****************************************************************************/
//  153 static tmrTimerType_t TMR_GetTimerType 
//  154 ( 
//  155     tmrTimerID_t timerID 
//  156 );
//  157 
//  158 /******************************************************************************
//  159  * NAME: TMR_SetTimerType
//  160  * DESCRIPTION: Set the timer type
//  161  * PARAMETERS:  IN: timerID - the timer ID
//  162  * 			    IN: type - timer type
//  163  * RETURN: none
//  164  * NOTES: none
//  165  *****************************************************************************/
//  166 static void TMR_SetTimerType
//  167 (
//  168     tmrTimerID_t timerID,
//  169     tmrTimerType_t type
//  170 );
//  171 
//  172 /******************************************************************************
//  173  * NAME: TmrTicksFromMilliseconds
//  174  * DESCRIPTION: Convert milliseconds to ticks
//  175  * PARAMETERS:  IN: milliseconds
//  176  * RETURN: tmrTimerTicks32_t - ticks number
//  177  * NOTES: none
//  178  *****************************************************************************/
//  179 static tmrTimerTicks32_t TmrTicksFromMilliseconds 
//  180 ( 
//  181     tmrTimeInMilliseconds_t milliseconds 
//  182 );
//  183 
//  184 /******************************************************************************
//  185 *******************************************************************************
//  186 * Private functions
//  187 *******************************************************************************
//  188 ******************************************************************************/
//  189 
//  190 /******************************************************************************
//  191 * NAME: TMR_GetTimerStatus
//  192 * DESCRIPTION: Returns the timer status
//  193 * PARAMETERS:  IN: timerID - the timer ID
//  194 * RETURN: see definition of tmrStatus_t
//  195 * NOTES: none
//  196 ******************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  197 static tmrStatus_t TMR_GetTimerStatus
//  198 (
//  199     tmrTimerID_t timerID
//  200 )
//  201 {
//  202     return maTmrTimerStatusTable[timerID] & mTimerStatusMask_c;
TMR_GetTimerStatus:
        LDR      R1,??DataTable13
        UXTB     R0,R0
        LDRB     R1,[R1, R0]
        MOVS     R0,#+224
        ANDS     R0,R0,R1
        BX       LR               ;; return
//  203 }
//  204 
//  205 /******************************************************************************
//  206 * NAME: TMR_SetTimerStatus
//  207 * DESCRIPTION: Set the timer status
//  208 * PARAMETERS:  IN: timerID - the timer ID
//  209 * 			   IN: status - the status of the timer	
//  210 * RETURN: None
//  211 * NOTES: none
//  212 ******************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  213 static void TMR_SetTimerStatus
//  214 (
//  215     tmrTimerID_t timerID, 
//  216     tmrStatus_t status
//  217 )
//  218 {
//  219     maTmrTimerStatusTable[timerID] = (maTmrTimerStatusTable[timerID] & ~mTimerStatusMask_c) | status;
TMR_SetTimerStatus:
        LDR      R2,??DataTable13
        UXTB     R0,R0
        LDRB     R2,[R2, R0]
        LSLS     R2,R2,#+27       ;; ZeroExtS R2,R2,#+27,#+27
        LSRS     R2,R2,#+27
        ORRS     R2,R2,R1
        LDR      R3,??DataTable13
        UXTB     R0,R0
        STRB     R2,[R3, R0]
//  220 }
        BX       LR               ;; return
//  221 
//  222 /******************************************************************************
//  223 * NAME: TMR_GetTimerType
//  224 * DESCRIPTION: Returns the timer type
//  225 * PARAMETERS:  IN: timerID - the timer ID
//  226 * RETURN: see definition of tmrTimerType_t
//  227 * NOTES: none
//  228 ******************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  229 static tmrTimerType_t TMR_GetTimerType
//  230 (
//  231     tmrTimerID_t timerID
//  232 )
//  233 {
//  234     return maTmrTimerStatusTable[timerID] & mTimerType_c;
TMR_GetTimerType:
        LDR      R1,??DataTable13
        UXTB     R0,R0
        LDRB     R0,[R1, R0]
        LSLS     R0,R0,#+28       ;; ZeroExtS R0,R0,#+28,#+28
        LSRS     R0,R0,#+28
        BX       LR               ;; return
//  235 }
//  236 
//  237 /******************************************************************************
//  238 * NAME: TMR_SetTimerType
//  239 * DESCRIPTION: Set the timer type
//  240 * PARAMETERS:  IN: timerID - the timer ID
//  241 * 			   IN: type - timer type	
//  242 * RETURN: none
//  243 * NOTES: none
//  244 ******************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  245 static void TMR_SetTimerType
//  246 (
//  247     tmrTimerID_t timerID, 
//  248     tmrTimerType_t type
//  249 )
//  250 {
//  251     maTmrTimerStatusTable[timerID] = (maTmrTimerStatusTable[timerID] & ~mTimerType_c) | type;
TMR_SetTimerType:
        LDR      R2,??DataTable13
        UXTB     R0,R0
        LDRB     R2,[R2, R0]
        MOVS     R3,#+240
        ANDS     R3,R3,R2
        ORRS     R3,R3,R1
        LDR      R2,??DataTable13
        UXTB     R0,R0
        STRB     R3,[R2, R0]
//  252 } 
        BX       LR               ;; return
//  253 
//  254 /******************************************************************************
//  255  * NAME: TmrTicksFromMilliseconds
//  256  * DESCRIPTION: Convert milliseconds to ticks
//  257  * PARAMETERS:  IN: milliseconds
//  258  * RETURN: tmrTimerTicks32_t - ticks number
//  259  * NOTES: none
//  260  ******************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  261 static tmrTimerTicks32_t TmrTicksFromMilliseconds
//  262 (
//  263     tmrTimeInMilliseconds_t milliseconds
//  264 )
//  265 {
//  266     return (milliseconds * (mClkSourceKhz/(0x01<<gTPMxSC_PrescaleCount_c)));
TmrTicksFromMilliseconds:
        LDR      R1,??DataTable13_1
        LDR      R1,[R1, #+0]
        LSRS     R1,R1,#+5
        MULS     R0,R1,R0
        BX       LR               ;; return
//  267 } 
//  268 
//  269 /******************************************************************************
//  270 *******************************************************************************
//  271 * Public functions
//  272 *******************************************************************************
//  273 ******************************************************************************/
//  274 
//  275 /******************************************************************************
//  276  * NAME: TMR_Init
//  277  * DESCRIPTION: initialize the timer module
//  278  * PARAMETERS: -
//  279  * RETURN: -
//  280  ******************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  281 void TMR_Init 
//  282 (
//  283     void
//  284 )
//  285 {
TMR_Init:
        PUSH     {R4,LR}
//  286 
//  287     /* Enable interrupts for TPM */
//  288     NVIC_EnableIRQ(gTMR_TPMIrqNo);
        MOVS     R0,#+17
        BL       NVIC_EnableIRQ
//  289     /* Set timer IRQ priority */
//  290     NVIC_SetPriority(gTMR_TPMIrqNo, gTMR_TPMInterruptPriority);
        MOVS     R1,#+7
        MOVS     R0,#+17
        BL       NVIC_SetPriority
//  291   
//  292     /*Select the clock source for the TPM counter clock*/
//  293     /* 1-> MCGFLLCLK clock or MCGPLLCLK/2 */
//  294     gTPMx_SIM_SOPT_REG_c |= gTPMxSC_ClockSource_c;	
        LDR      R0,??DataTable13_2  ;; 0x40048004
        LDR      R0,[R0, #+0]
        MOVS     R1,#+128
        LSLS     R1,R1,#+17       ;; #+16777216
        ORRS     R1,R1,R0
        LDR      R0,??DataTable13_2  ;; 0x40048004
        STR      R1,[R0, #+0]
//  295              
//  296     /* Configure a TPM channel*/
//  297     /* Setup the system clock gating */
//  298     #if(gTMR_TPMx == 0)
//  299     gTPM0_SIM_SCGC_REG_c |= SIM_SCGC6_TPM0_MASK;
        LDR      R0,??DataTable13_3  ;; 0x4004803c
        LDR      R0,[R0, #+0]
        MOVS     R1,#+128
        LSLS     R1,R1,#+17       ;; #+16777216
        ORRS     R1,R1,R0
        LDR      R0,??DataTable13_3  ;; 0x4004803c
        STR      R1,[R0, #+0]
//  300     #elif (gTMR_TPMx == 1)
//  301     gTPM1_SIM_SCGC_REG_c |= SIM_SCGC6_TPM1_MASK;
//  302     #endif
//  303     
//  304     /* Write to the TOF bit in the TPMx_SC register to clear the interrupt flag */                       
//  305     gTPMxSC_c |= TPM_SC_TOF_MASK;
        LDR      R0,??DataTable13_4  ;; 0x40038000
        LDR      R0,[R0, #+0]
        MOVS     R1,#+128
        ORRS     R1,R1,R0
        LDR      R0,??DataTable13_4  ;; 0x40038000
        STR      R1,[R0, #+0]
//  306     
//  307     /*Clear Status and Control register*/
//  308     gTPMxSC_c = gTPMxSC_ClearRegister_c;
        MOVS     R0,#+0
        LDR      R1,??DataTable13_4  ;; 0x40038000
        STR      R0,[R1, #+0]
//  309     
//  310     /*Reset counter register - stop the counter*/
//  311     gTPMxCNT = gTPMxCNT_ClearRegister_c;        
        MOVS     R0,#+0
        LDR      R1,??DataTable13_5  ;; 0x40038004
        STR      R0,[R1, #+0]
//  312         
//  313     /*Write to the CHF bit in the TPMx_CnSC register to clear the interrupt flag*/
//  314     gTPMxCnSC_c |= TPM_CnSC_CHF_MASK;
        LDR      R0,??DataTable13_6  ;; 0x4003800c
        LDR      R0,[R0, #+0]
        MOVS     R1,#+128
        ORRS     R1,R1,R0
        LDR      R0,??DataTable13_6  ;; 0x4003800c
        STR      R1,[R0, #+0]
//  315     
//  316     /* Clear channel status and control register */
//  317     gTPMxCnSC_c = gTPMxCnSC_c_ClearRegister_c;     
        MOVS     R0,#+0
        LDR      R1,??DataTable13_6  ;; 0x4003800c
        STR      R0,[R1, #+0]
//  318     
//  319     /*Set to Output compare, Toggle ouput on match*/
//  320     gTPMxCnSC_c = (TPM_CnSC_CHIE_MASK | TPM_CnSC_MSA_MASK |TPM_CnSC_ELSA_MASK) ;
        MOVS     R0,#+84
        LDR      R1,??DataTable13_6  ;; 0x4003800c
        STR      R0,[R1, #+0]
//  321     
//  322     /* Count to maximum (0xffff - 2*4ms(in ticks)), to be sure that the currentTimeInTicks 
//  323     will never roll over previousTimeInTicks in the TMR_Task() */
//  324     mMaxToCountDown_c = 0xFFFF - TmrTicksFromMilliseconds(8); 
        LDR      R4,??DataTable13_7  ;; 0xffff
        MOVS     R0,#+8
        BL       TmrTicksFromMilliseconds
        SUBS     R0,R4,R0
        LDR      R1,??DataTable13_8
        STRH     R0,[R1, #+0]
//  325     /* The TMR_Task()event will not be issued faster than 4ms*/
//  326     mTicksFor4ms = TmrTicksFromMilliseconds(4);
        MOVS     R0,#+4
        BL       TmrTicksFromMilliseconds
        LDR      R1,??DataTable13_9
        STR      R0,[R1, #+0]
//  327  
//  328 }
        POP      {R4,PC}          ;; return
//  329 
//  330 /******************************************************************************
//  331  * NAME: TMR_NotifyClkChanged
//  332  * DESCRIPTION: This function is called when the clock is changed
//  333  * PARAMETERS: IN: clkKhz (uint32_t) - new clock
//  334  * RETURN: -
//  335  *****************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  336 void TMR_NotifyClkChanged
//  337 (
//  338     uint32_t clkKhz
//  339 )
//  340 {
TMR_NotifyClkChanged:
        PUSH     {R3-R5,LR}
        MOVS     R4,R0
//  341     mClkSourceKhz = clkKhz;
        LDR      R0,??DataTable13_1
        STR      R4,[R0, #+0]
//  342     /* Clock was changed, so calculate again  mMaxToCountDown_c.
//  343     Count to maximum (0xffff - 2*4ms(in ticks)), to be sure that the currentTimeInTicks 
//  344     will never roll over previousTimeInTicks in the TMR_Task() */
//  345     mMaxToCountDown_c = 0xFFFF - TmrTicksFromMilliseconds(8); 
        LDR      R5,??DataTable13_7  ;; 0xffff
        MOVS     R0,#+8
        BL       TmrTicksFromMilliseconds
        SUBS     R0,R5,R0
        LDR      R1,??DataTable13_8
        STRH     R0,[R1, #+0]
//  346     /* The TMR_Task()event will not be issued faster than 4ms*/
//  347     mTicksFor4ms = TmrTicksFromMilliseconds(4);  
        MOVS     R0,#+4
        BL       TmrTicksFromMilliseconds
        LDR      R1,??DataTable13_9
        STR      R0,[R1, #+0]
//  348 }
        POP      {R0,R4,R5,PC}    ;; return
//  349 
//  350 /******************************************************************************
//  351  * NAME: TMR_AllocateTimer
//  352  * DESCRIPTION: allocate a timer
//  353  * PARAMETERS: -
//  354  * RETURN: timer ID
//  355  *****************************************************************************/
//  356 

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  357 tmrTimerID_t TMR_AllocateTimer
//  358 (
//  359     void
//  360 )
//  361 {
TMR_AllocateTimer:
        PUSH     {R4,LR}
//  362     uint32_t i;
//  363   
//  364     for (i = 0; i < NumberOfElements(maTmrTimerTable); ++i) 
        MOVS     R0,#+0
        MOVS     R4,R0
??TMR_AllocateTimer_0:
        CMP      R4,#+3
        BCS      ??TMR_AllocateTimer_1
//  365     {
//  366         if (!TMR_IsTimerAllocated(i)) 
        LDR      R0,??DataTable13
        LDRB     R0,[R0, R4]
        CMP      R0,#+0
        BNE      ??TMR_AllocateTimer_2
//  367         {
//  368             TMR_SetTimerStatus(i, mTmrStatusInactive_c);
        MOVS     R1,#+128
        MOVS     R0,R4
        UXTB     R0,R0
        BL       TMR_SetTimerStatus
//  369             return i;
        MOVS     R0,R4
        UXTB     R0,R0
        B        ??TMR_AllocateTimer_3
//  370         }
//  371    }
??TMR_AllocateTimer_2:
        ADDS     R4,R4,#+1
        B        ??TMR_AllocateTimer_0
//  372   
//  373    return gTmrInvalidTimerID_c;
??TMR_AllocateTimer_1:
        MOVS     R0,#+255
??TMR_AllocateTimer_3:
        POP      {R4,PC}          ;; return
//  374 }                                      
//  375 
//  376 /******************************************************************************
//  377  * NAME: TMR_AreAllTimersOff
//  378  * DESCRIPTION: Check if all timers except the LP timers are OFF.
//  379  * PARAMETERS: -
//  380  * RETURN: TRUE if there are no active non-low power timers, FALSE otherwise
//  381  *****************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  382 bool_t TMR_AreAllTimersOff
//  383 (
//  384     void
//  385 )
//  386 {
TMR_AreAllTimersOff:
        PUSH     {LR}
//  387     return !numberOfActiveTimers;
        LDR      R0,??DataTable14
        LDRB     R0,[R0, #+0]
        CMP      R0,#+0
        BNE      ??TMR_AreAllTimersOff_0
        MOVS     R0,#+1
        B        ??TMR_AreAllTimersOff_1
??TMR_AreAllTimersOff_0:
        MOVS     R0,#+0
??TMR_AreAllTimersOff_1:
        UXTB     R0,R0
        POP      {PC}             ;; return
//  388 }                                      
//  389 
//  390 /******************************************************************************
//  391  * NAME: TMR_FreeTimer
//  392  * DESCRIPTION: Free a timer
//  393  * PARAMETERS:  IN: timerID - the ID of the timer
//  394  * RETURN: -
//  395  * NOTES: Safe to call even if the timer is running.
//  396  *        Harmless if the timer is already free.
//  397  *****************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  398 void TMR_FreeTimer
//  399 (
//  400     tmrTimerID_t timerID
//  401 )
//  402 {
TMR_FreeTimer:
        PUSH     {R4,LR}
        MOVS     R4,R0
//  403     TMR_StopTimer(timerID);
        MOVS     R0,R4
        UXTB     R0,R0
        BL       TMR_StopTimer
//  404     TMR_MarkTimerFree(timerID);
        MOVS     R0,#+0
        LDR      R1,??DataTable13
        UXTB     R4,R4
        STRB     R0,[R1, R4]
//  405 }                                       
        POP      {R4,PC}          ;; return
//  406 
//  407 /******************************************************************************
//  408  * NAME: TMR_InterruptHandler
//  409  * DESCRIPTION: Timer Module Interrupt Service Routine
//  410  * PARAMETERS: -
//  411  * RETURN: -
//  412  * NOTES: This function have to be added to Interrupt Vector Table
//  413  *****************************************************************************/
//  414 

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  415 void TMR_InterruptHandler
//  416 (
//  417     void
//  418 ) 
//  419 {
TMR_InterruptHandler:
        PUSH     {R7,LR}
//  420  
//  421     /* Clearing the overflow flag requires writing to the Flag bit. */
//  422 
//  423     if(gTPMxSC_c & gTPMxSC_TOF_c) 
        LDR      R0,??DataTable13_4  ;; 0x40038000
        LDR      R0,[R0, #+0]
        LSLS     R0,R0,#+24
        BPL      ??TMR_InterruptHandler_0
//  424     {
//  425         gTPMxSC_c  |=  gTPMxSC_TOF_c;           
        LDR      R0,??DataTable13_4  ;; 0x40038000
        LDR      R0,[R0, #+0]
        MOVS     R1,#+128
        ORRS     R1,R1,R0
        LDR      R0,??DataTable13_4  ;; 0x40038000
        STR      R1,[R0, #+0]
//  426     }
//  427 
//  428     if ( gTPMxCnSC_c & gTPMxCnSC_CHF_c ) 
??TMR_InterruptHandler_0:
        LDR      R0,??DataTable13_6  ;; 0x4003800c
        LDR      R0,[R0, #+0]
        LSLS     R0,R0,#+24
        BPL      ??TMR_InterruptHandler_1
//  429     {
//  430         
//  431         gTPMxCnSC_c |= gTPMxCnSC_CHF_c;
        LDR      R0,??DataTable13_6  ;; 0x4003800c
        LDR      R0,[R0, #+0]
        MOVS     R1,#+128
        ORRS     R1,R1,R0
        LDR      R0,??DataTable13_6  ;; 0x4003800c
        STR      R1,[R0, #+0]
//  432         TMR_Task();  
        BL       TMR_Task
//  433     }
//  434     
//  435 }
??TMR_InterruptHandler_1:
        POP      {R0,PC}          ;; return
//  436 
//  437 /******************************************************************************
//  438  * NAME: TMR_IsTimerActive
//  439  * DESCRIPTION: Check if a specified timer is active
//  440  * PARAMETERS: IN: timerID - the ID of the timer
//  441  * RETURN: TRUE if the timer (specified by the timerID) is active,
//  442  *         FALSE otherwise
//  443  *****************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  444 bool_t TMR_IsTimerActive
//  445 (
//  446     tmrTimerID_t timerID
//  447 )
//  448 {
TMR_IsTimerActive:
        PUSH     {R4,LR}
        MOVS     R4,R0
//  449     return TMR_GetTimerStatus(timerID) == mTmrStatusActive_c;
        MOVS     R0,R4
        UXTB     R0,R0
        BL       TMR_GetTimerStatus
        CMP      R0,#+32
        BNE      ??TMR_IsTimerActive_0
        MOVS     R0,#+1
        B        ??TMR_IsTimerActive_1
??TMR_IsTimerActive_0:
        MOVS     R0,#+0
??TMR_IsTimerActive_1:
        UXTB     R0,R0
        POP      {R4,PC}          ;; return
//  450 } 
//  451 
//  452 /******************************************************************************
//  453  * NAME: TMR_StartTimer (BeeStack or application)
//  454  * DESCRIPTION: Start a specified timer
//  455  * PARAMETERS: IN: timerId - the ID of the timer
//  456  *             IN: timerType - the type of the timer
//  457  *             IN: timeInMilliseconds - time expressed in millisecond units
//  458  *             IN: pTPMrCallBack - callback function
//  459  * RETURN: -
//  460  * NOTES: When the timer expires, the callback function is called in
//  461  *        non-interrupt context. If the timer is already running when
//  462  *        this function is called, it will be stopped and restarted.
//  463  *****************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  464 void TMR_StartTimer
//  465 (
//  466     tmrTimerID_t timerID,                       
//  467     tmrTimerType_t timerType,                   
//  468     tmrTimeInMilliseconds_t timeInMilliseconds, 
//  469    void (*pTPMrCallBack)(tmrTimerID_t)       
//  470          
//  471    
//  472 )
//  473 {
TMR_StartTimer:
        PUSH     {R1,R4-R7,LR}
        MOVS     R4,R0
        MOVS     R7,R2
        MOVS     R6,R3
//  474     tmrTimerTicks32_t intervalInTicks;
//  475 
//  476     /* Stopping an already stopped timer is harmless. */
//  477     TMR_StopTimer(timerID);
        MOVS     R0,R4
        UXTB     R0,R0
        BL       TMR_StopTimer
//  478 
//  479     intervalInTicks = TmrTicksFromMilliseconds(timeInMilliseconds);
        MOVS     R0,R7
        BL       TmrTicksFromMilliseconds
        MOVS     R5,R0
//  480     if (!intervalInTicks) 
        CMP      R5,#+0
        BNE      ??TMR_StartTimer_0
//  481     {
//  482         intervalInTicks = 1;
        MOVS     R0,#+1
        MOVS     R5,R0
//  483     }
//  484 
//  485     TMR_SetTimerType(timerID, timerType);
??TMR_StartTimer_0:
        MOV      R0,SP
        LDRB     R1,[R0, #+0]
        MOVS     R0,R4
        UXTB     R0,R0
        BL       TMR_SetTimerType
//  486     maTmrTimerTable[timerID].intervalInTicks = intervalInTicks;
        LDR      R0,??DataTable15
        UXTB     R4,R4
        MOVS     R1,#+12
        MULS     R1,R4,R1
        STR      R5,[R0, R1]
//  487     maTmrTimerTable[timerID].remainingTicks = intervalInTicks;
        LDR      R0,??DataTable15
        UXTB     R4,R4
        MOVS     R1,#+12
        MULS     R1,R4,R1
        ADDS     R0,R0,R1
        STR      R5,[R0, #+4]
//  488     maTmrTimerTable[timerID].pfCallBack = pTPMrCallBack;
        LDR      R0,??DataTable15
        UXTB     R4,R4
        MOVS     R1,#+12
        MULS     R1,R4,R1
        ADDS     R0,R0,R1
        STR      R6,[R0, #+8]
//  489  
//  490     
//  491     /* Enable timer, the timer task will do the rest of the work. */
//  492     TMR_EnableTimer(timerID);
        MOVS     R0,R4
        UXTB     R0,R0
        BL       TMR_EnableTimer
//  493     
//  494     
//  495 }
        POP      {R0,R4-R7,PC}    ;; return
//  496 
//  497 /******************************************************************************
//  498  * NAME: TMR_StartMinuteTimer
//  499  * DESCRIPTION: Starts a minutes timer
//  500  * PARAMETERS:  IN: timerId - the ID of the timer
//  501  *              IN: timeInMinutes - time expressed in minutes
//  502  *              IN: pTPMrCallBack - callback function
//  503  * RETURN: None
//  504  * NOTES: Customized form of TMR_StartTimer(). This is a single shot timer.
//  505  *        There are no interval minute timers.
//  506  *****************************************************************************/
//  507  #if gTMR_EnableMinutesSecondsTimers_d

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  508 void TMR_StartMinuteTimer
//  509 (
//  510     tmrTimerID_t timerId, 
//  511     tmrTimeInMinutes_t timeInMinutes, 
//  512     void (*pTPMrCallBack)(tmrTimerID_t)
//  513     
//  514 )
//  515 {
TMR_StartMinuteTimer:
        PUSH     {R4-R6,LR}
        MOVS     R6,R0
        MOVS     R5,R1
        MOVS     R4,R2
//  516     TMR_StartTimer(timerId, gTmrMinuteTimer_c, TmrMinutes(timeInMinutes), pTPMrCallBack);
        MOVS     R3,R4
        LDR      R2,??DataTable15_1  ;; 0xea60
        MULS     R2,R5,R2
        MOVS     R1,#+4
        MOVS     R0,R6
        UXTB     R0,R0
        BL       TMR_StartTimer
//  517 }
        POP      {R4-R6,PC}       ;; return
//  518 #endif
//  519   
//  520 /******************************************************************************
//  521  * NAME: TMR_StartSecondTimer
//  522  * DESCRIPTION: Starts a seconds timer
//  523  * PARAMETERS:  IN: timerId - the ID of the timer
//  524  *              IN: timeInSeconds - time expressed in seconds
//  525  *              IN: pTPMrCallBack - callback function
//  526  * RETURN: None
//  527  * NOTES: Customized form of TMR_StartTimer(). This is a single shot timer.
//  528  *        There are no interval seconds timers.
//  529  *****************************************************************************/
//  530  #if gTMR_EnableMinutesSecondsTimers_d

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  531 void TMR_StartSecondTimer
//  532 (
//  533     tmrTimerID_t timerId, 
//  534     tmrTimeInSeconds_t timeInSeconds, 
//  535     void (*pTPMrCallBack)(tmrTimerID_t)
//  536    
//  537 ) 
//  538 {
TMR_StartSecondTimer:
        PUSH     {R4-R6,LR}
        MOVS     R6,R0
        MOVS     R5,R1
        MOVS     R4,R2
//  539     TMR_StartTimer(timerId, gTmrSecondTimer_c, TmrSeconds(timeInSeconds), pTPMrCallBack);
        MOVS     R3,R4
        MOVS     R2,#+250
        LSLS     R2,R2,#+2        ;; #+1000
        MULS     R2,R5,R2
        MOVS     R1,#+8
        MOVS     R0,R6
        UXTB     R0,R0
        BL       TMR_StartTimer
//  540 }
        POP      {R4-R6,PC}       ;; return
//  541 #endif
//  542  
//  543 /******************************************************************************
//  544  * NAME: TMR_StartIntervalTimer
//  545  * DESCRIPTION: Starts an interval count timer
//  546  * PARAMETERS:  IN: timerId - the ID of the timer
//  547  *              IN: timeInMilliseconds - time expressed in milliseconds
//  548  *              IN: pTPMrCallBack - callback function
//  549  * RETURN: None
//  550  * NOTES: Customized form of TMR_StartTimer()
//  551  *****************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  552 void TMR_StartIntervalTimer
//  553 (
//  554     tmrTimerID_t timerID,
//  555     tmrTimeInMilliseconds_t timeInMilliseconds,
//  556     void (*pTPMrCallBack)(tmrTimerID_t)
//  557     
//  558 )
//  559 {
TMR_StartIntervalTimer:
        PUSH     {R4-R6,LR}
        MOVS     R6,R0
        MOVS     R5,R1
        MOVS     R4,R2
//  560     TMR_StartTimer(timerID, gTmrIntervalTimer_c, timeInMilliseconds, pTPMrCallBack);
        MOVS     R3,R4
        MOVS     R2,R5
        MOVS     R1,#+2
        MOVS     R0,R6
        UXTB     R0,R0
        BL       TMR_StartTimer
//  561 }
        POP      {R4-R6,PC}       ;; return
//  562 
//  563 /******************************************************************************
//  564  * NAME: TMR_StartSingleShotTimer
//  565  * DESCRIPTION: Starts an single-shot timer
//  566  * PARAMETERS:  IN: timerId - the ID of the timer
//  567  *              IN: timeInMilliseconds - time expressed in milliseconds
//  568  *              IN: pTPMrCallBack - callback function
//  569  * RETURN: None
//  570  * NOTES: Customized form of TMR_StartTimer()
//  571  *****************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  572 void TMR_StartSingleShotTimer
//  573 (
//  574     tmrTimerID_t timerID,
//  575     tmrTimeInMilliseconds_t timeInMilliseconds,
//  576     void (*pTPMrCallBack)(tmrTimerID_t)
//  577     
//  578 )
//  579 {
TMR_StartSingleShotTimer:
        PUSH     {R4-R6,LR}
        MOVS     R6,R0
        MOVS     R5,R1
        MOVS     R4,R2
//  580     TMR_StartTimer(timerID, gTmrSingleShotTimer_c, timeInMilliseconds, pTPMrCallBack);
        MOVS     R3,R4
        MOVS     R2,R5
        MOVS     R1,#+1
        MOVS     R0,R6
        UXTB     R0,R0
        BL       TMR_StartTimer
//  581 }
        POP      {R4-R6,PC}       ;; return
//  582 
//  583 /******************************************************************************
//  584  * NAME: TMR_StopTimer
//  585  * DESCRIPTION: Stop a timer
//  586  * PARAMETERS:  IN: timerID - the ID of the timer
//  587  * RETURN: None
//  588  * NOTES: Associated timer callback function is not called, even if the timer
//  589  *        expires. Does not frees the timer. Safe to call anytime, regardless
//  590  *        of the state of the timer.
//  591  *****************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  592 void TMR_StopTimer
//  593 (
//  594     tmrTimerID_t timerID
//  595 )
//  596 {
TMR_StopTimer:
        PUSH     {R4-R6,LR}
        MOVS     R4,R0
//  597     tmrStatus_t status;
//  598     uint32_t saveInt;				
//  599     
//  600 #if defined(IAR)	
//  601     saveInt = IntDisableAll();		
        BL       IntDisableAll
        MOVS     R6,R0
//  602 #elif defined (CW)
//  603     IntDisableAll(saveInt);			
//  604 #endif
//  605     
//  606     status = TMR_GetTimerStatus(timerID);
        MOVS     R0,R4
        UXTB     R0,R0
        BL       TMR_GetTimerStatus
        MOVS     R5,R0
//  607     
//  608     if ( (status == mTmrStatusActive_c) || (status == mTmrStatusReady_c) ) 
        UXTB     R5,R5
        CMP      R5,#+32
        BEQ      ??TMR_StopTimer_0
        UXTB     R5,R5
        CMP      R5,#+64
        BNE      ??TMR_StopTimer_1
//  609     {
//  610         TMR_SetTimerStatus(timerID, mTmrStatusInactive_c);
??TMR_StopTimer_0:
        MOVS     R1,#+128
        MOVS     R0,R4
        UXTB     R0,R0
        BL       TMR_SetTimerStatus
//  611         DecrementActiveTimerNumber(TMR_GetTimerType(timerID));
        LDR      R0,??DataTable15_2
        LDRB     R0,[R0, #+0]
        SUBS     R0,R0,#+1
        LDR      R1,??DataTable15_2
        STRB     R0,[R1, #+0]
//  612         /* if no sw active timers are enabled, */
//  613         /* call the TMR_Task() to countdown the ticks and stop the hw timer*/
//  614         if (!numberOfActiveTimers) 
        LDR      R0,??DataTable15_2
        LDRB     R0,[R0, #+0]
        CMP      R0,#+0
        BNE      ??TMR_StopTimer_1
//  615             TMR_Task();
        BL       TMR_Task
//  616     }	
//  617 
//  618     IntRestoreAll(saveInt);
??TMR_StopTimer_1:
        MOVS     R0,R6
        BL       IntRestoreAll
//  619 }  
        POP      {R4-R6,PC}       ;; return

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable13:
        DC32     maTmrTimerStatusTable

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable13_1:
        DC32     mClkSourceKhz

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable13_2:
        DC32     0x40048004

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable13_3:
        DC32     0x4004803c

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable13_4:
        DC32     0x40038000

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable13_5:
        DC32     0x40038004

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable13_6:
        DC32     0x4003800c

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable13_7:
        DC32     0xffff

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable13_8:
        DC32     mMaxToCountDown_c

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable13_9:
        DC32     mTicksFor4ms
//  620 
//  621 /******************************************************************************
//  622  * NAME: TMR_Task
//  623  * DESCRIPTION: Timer task. 
//  624  *              Called by the kernel when the timer ISR posts a timer event.
//  625  * PARAMETERS:  IN: events - timer events mask
//  626  * RETURN: None
//  627  * NOTES: none
//  628  *****************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  629 void TMR_Task
//  630 (
//  631     void
//  632 )
//  633 {
TMR_Task:
        PUSH     {R4-R7,LR}
        SUB      SP,SP,#+12
//  634     tmrTimerTicks16_t nextInterruptTime;
//  635     pTPMrCallBack_t pfCallBack;
//  636     tmrTimerTicks16_t currentTimeInTicks;
//  637     tmrTimerStatus_t status;
//  638     tmrTimerTicks16_t ticksSinceLastHere, ticksdiff; 
//  639     uint8_t timerID;
//  640     //unsigned int saveInt;
//  641     tmrTimerType_t timerType;
//  642 
//  643 
//  644     TPMReadCNTRegister(currentTimeInTicks);
        LDR      R0,??DataTable15_3  ;; 0x40038004
        LDR      R0,[R0, #+0]
        MOV      R1,SP
        STRH     R0,[R1, #+2]
//  645 
//  646     /* calculate difference between current and previous.  */
//  647     ticksSinceLastHere = (currentTimeInTicks - previousTimeInTicks);
        MOV      R0,SP
        MOV      R1,SP
        LDRH     R1,[R1, #+2]
        LDR      R2,??DataTable15_4
        LDRH     R2,[R2, #+0]
        SUBS     R1,R1,R2
        STRH     R1,[R0, #+4]
//  648     /* remember for next time */
//  649     previousTimeInTicks = currentTimeInTicks;
        MOV      R0,SP
        LDRH     R0,[R0, #+2]
        LDR      R1,??DataTable15_4
        STRH     R0,[R1, #+0]
//  650   
//  651     for (timerID = 0; timerID < NumberOfElements(maTmrTimerTable); ++timerID) 
        MOVS     R0,#+0
        MOVS     R5,R0
??TMR_Task_0:
        UXTB     R5,R5
        CMP      R5,#+3
        BCS      ??TMR_Task_1
//  652     {
//  653         status = TMR_GetTimerStatus(timerID);
        MOVS     R0,R5
        UXTB     R0,R0
        BL       TMR_GetTimerStatus
        MOV      R1,SP
        STRB     R0,[R1, #+0]
//  654         /* If TMR_StartTimer() has been called for this timer, start it's count */
//  655         /* down as of now. */
//  656         if (status == mTmrStatusReady_c) 
        MOV      R0,SP
        LDRB     R0,[R0, #+0]
        CMP      R0,#+64
        BNE      ??TMR_Task_2
//  657         {
//  658             TMR_SetTimerStatus(timerID, mTmrStatusActive_c);
        MOVS     R1,#+32
        MOVS     R0,R5
        UXTB     R0,R0
        BL       TMR_SetTimerStatus
//  659             continue;
        B        ??TMR_Task_3
//  660         }
//  661     
//  662         /* Ignore any timer that is not active. */
//  663         if (status != mTmrStatusActive_c) 
??TMR_Task_2:
        MOV      R0,SP
        LDRB     R0,[R0, #+0]
        CMP      R0,#+32
        BNE      ??TMR_Task_3
//  664         {
//  665             continue;
//  666         }
//  667 
//  668         /* This timer is active. Decrement it's countdown.. */
//  669         if (maTmrTimerTable[timerID].remainingTicks > ticksSinceLastHere) 
??TMR_Task_4:
        MOV      R0,SP
        LDRH     R0,[R0, #+4]
        LDR      R1,??DataTable15
        UXTB     R5,R5
        MOVS     R2,#+12
        MULS     R2,R5,R2
        ADDS     R1,R1,R2
        LDR      R1,[R1, #+4]
        CMP      R0,R1
        BCS      ??TMR_Task_5
//  670         {
//  671             maTmrTimerTable[timerID].remainingTicks -= ticksSinceLastHere;
        LDR      R0,??DataTable15
        UXTB     R5,R5
        MOVS     R1,#+12
        MULS     R1,R5,R1
        ADDS     R0,R0,R1
        LDR      R0,[R0, #+4]
        MOV      R1,SP
        LDRH     R1,[R1, #+4]
        SUBS     R0,R0,R1
        LDR      R1,??DataTable15
        UXTB     R5,R5
        MOVS     R2,#+12
        MULS     R2,R5,R2
        ADDS     R1,R1,R2
        STR      R0,[R1, #+4]
//  672             continue;
        B        ??TMR_Task_3
//  673         }
//  674 
//  675         timerType = TMR_GetTimerType(timerID);
??TMR_Task_5:
        MOVS     R0,R5
        UXTB     R0,R0
        BL       TMR_GetTimerType
        MOV      R1,SP
        STRB     R0,[R1, #+1]
//  676         /* If this is an interval timer, restart it. Otherwise, mark it as inactive. */
//  677         if ( (timerType & gTmrSingleShotTimer_c) ||
//  678                 (timerType & gTmrSetMinuteTimer_c) ||
//  679                 (timerType & gTmrSetSecondTimer_c)  ) 
        MOV      R0,SP
        LDRB     R0,[R0, #+1]
        MOVS     R1,#+13
        TST      R0,R1
        BEQ      ??TMR_Task_6
//  680         {
//  681             TMR_StopTimer(timerID);
        MOVS     R0,R5
        UXTB     R0,R0
        BL       TMR_StopTimer
        B        ??TMR_Task_7
//  682         } 
//  683         else 
//  684         {
//  685             maTmrTimerTable[timerID].remainingTicks = maTmrTimerTable[timerID].intervalInTicks;
??TMR_Task_6:
        LDR      R0,??DataTable15
        UXTB     R5,R5
        MOVS     R1,#+12
        MULS     R1,R5,R1
        LDR      R0,[R0, R1]
        LDR      R1,??DataTable15
        UXTB     R5,R5
        MOVS     R2,#+12
        MULS     R2,R5,R2
        ADDS     R1,R1,R2
        STR      R0,[R1, #+4]
//  686         }
//  687         /* This timer has expired. */
//  688         pfCallBack = maTmrTimerTable[timerID].pfCallBack;     
??TMR_Task_7:
        LDR      R0,??DataTable15
        UXTB     R5,R5
        MOVS     R1,#+12
        MULS     R1,R5,R1
        ADDS     R0,R0,R1
        LDR      R0,[R0, #+8]
        MOVS     R7,R0
//  689         /*Call callback if it is not NULL
//  690         This is done after the timer got updated,
//  691         in case the timer gets stopped or restarted in the callback*/
//  692         if (pfCallBack)                                       
        MOVS     R0,R7
        CMP      R0,#+0
        BEQ      ??TMR_Task_3
//  693         {      
//  694            pfCallBack(timerID);                   
        MOVS     R0,R5
        UXTB     R0,R0
        BLX      R7
//  695         }                                                     
//  696     }  /* for (timerID = 0; timerID < ... */
??TMR_Task_3:
        ADDS     R5,R5,#+1
        B        ??TMR_Task_0
//  697   
//  698     /* Find the shortest active timer. */
//  699     nextInterruptTime = mMaxToCountDown_c;
??TMR_Task_1:
        LDR      R0,??DataTable15_5
        LDRH     R0,[R0, #+0]
        MOVS     R4,R0
//  700     
//  701     for (timerID = 0; timerID < NumberOfElements(maTmrTimerTable); ++timerID) 
        MOVS     R0,#+0
        MOVS     R5,R0
??TMR_Task_8:
        UXTB     R5,R5
        CMP      R5,#+3
        BCS      ??TMR_Task_9
//  702     {
//  703         if (TMR_GetTimerStatus(timerID) == mTmrStatusActive_c) 
        MOVS     R0,R5
        UXTB     R0,R0
        BL       TMR_GetTimerStatus
        CMP      R0,#+32
        BNE      ??TMR_Task_10
//  704         {
//  705             if (nextInterruptTime > maTmrTimerTable[timerID].remainingTicks) 
        LDR      R0,??DataTable15
        UXTB     R5,R5
        MOVS     R1,#+12
        MULS     R1,R5,R1
        ADDS     R0,R0,R1
        LDR      R0,[R0, #+4]
        UXTH     R4,R4
        CMP      R0,R4
        BCS      ??TMR_Task_10
//  706             {
//  707                 nextInterruptTime = maTmrTimerTable[timerID].remainingTicks;
        LDR      R0,??DataTable15
        UXTB     R5,R5
        MOVS     R1,#+12
        MULS     R1,R5,R1
        ADDS     R0,R0,R1
        LDR      R0,[R0, #+4]
        MOVS     R4,R0
//  708             }
//  709         }
//  710     }
??TMR_Task_10:
        ADDS     R5,R5,#+1
        B        ??TMR_Task_8
//  711     
//  712     
//  713 	/* Check to be sure that the timer was not programmed in the past for different source clocks.
//  714 	 * The interrupts are now disabled.
//  715 	 */      	 
//  716 	TPMReadCNTRegister(ticksdiff);  
??TMR_Task_9:
        LDR      R0,??DataTable15_3  ;; 0x40038004
        LDR      R0,[R0, #+0]
        MOVS     R6,R0
//  717     
//  718     /* Number of ticks to be here */
//  719     ticksdiff = (uint16_t)(ticksdiff - currentTimeInTicks); 
        MOV      R0,SP
        LDRH     R0,[R0, #+2]
        SUBS     R6,R6,R0
//  720     
//  721     /* Next ticks to count already expired?? */
//  722     if(ticksdiff >= nextInterruptTime)
        UXTH     R6,R6
        UXTH     R4,R4
        CMP      R6,R4
        BCC      ??TMR_Task_11
//  723     {  
//  724         /* Is assumed that a task has to be executed in 4ms...
//  725     so if the ticks already expired enter in TMR_Task() after 4ms*/
//  726         nextInterruptTime = ticksdiff + mTicksFor4ms;
        LDR      R0,??DataTable15_6
        LDR      R0,[R0, #+0]
        ADDS     R0,R6,R0
        MOVS     R4,R0
        B        ??TMR_Task_12
//  727     } 
//  728     else 
//  729     {
//  730         /* Time reference is 4ms, so be sure that won't be loaded 
//  731            in Cmp Reg. less that 4ms in ticks */
//  732         if((nextInterruptTime - ticksdiff) < mTicksFor4ms) 
??TMR_Task_11:
        UXTH     R4,R4
        UXTH     R6,R6
        SUBS     R0,R4,R6
        LDR      R1,??DataTable15_6
        LDR      R1,[R1, #+0]
        CMP      R0,R1
        BCS      ??TMR_Task_12
//  733         {
//  734             nextInterruptTime = ticksdiff + mTicksFor4ms;
        LDR      R0,??DataTable15_6
        LDR      R0,[R0, #+0]
        ADDS     R0,R6,R0
        MOVS     R4,R0
//  735         }
//  736     }
//  737     /* Update the compare register */
//  738     nextInterruptTime += currentTimeInTicks;
??TMR_Task_12:
        MOV      R0,SP
        LDRH     R0,[R0, #+2]
        ADDS     R4,R4,R0
//  739     gTPMxCnV_c = nextInterruptTime;
        UXTH     R4,R4
        LDR      R0,??DataTable15_7  ;; 0x40038010
        STR      R4,[R0, #+0]
//  740   
//  741 	if (!numberOfActiveTimers) 
        LDR      R0,??DataTable14
        LDRB     R0,[R0, #+0]
        CMP      R0,#+0
        BNE      ??TMR_Task_13
//  742     {
//  743 		TPMStopTimerHardware();
        MOVS     R0,#+0
        LDR      R1,??DataTable15_8  ;; 0x40038000
        STR      R0,[R1, #+0]
//  744 		timerHardwareIsRunning = FALSE;
        MOVS     R0,#+0
        LDR      R1,??DataTable15_9
        STRB     R0,[R1, #+0]
        B        ??TMR_Task_14
//  745 	} 
//  746     else if (!timerHardwareIsRunning) 
??TMR_Task_13:
        LDR      R0,??DataTable15_9
        LDRB     R0,[R0, #+0]
        CMP      R0,#+0
        BNE      ??TMR_Task_14
//  747     {
//  748 		TPMStartTimerHardware();
        LDR      R0,??DataTable15_8  ;; 0x40038000
        LDR      R0,[R0, #+0]
        MOVS     R1,#+13
        ORRS     R1,R1,R0
        LDR      R0,??DataTable15_8  ;; 0x40038000
        STR      R1,[R0, #+0]
//  749 		timerHardwareIsRunning = TRUE;
        MOVS     R0,#+1
        LDR      R1,??DataTable15_9
        STRB     R0,[R1, #+0]
//  750 	}
//  751 }
??TMR_Task_14:
        POP      {R0-R2,R4-R7,PC}  ;; return

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable14:
        DC32     numberOfActiveTimers
//  752 
//  753 /******************************************************************************
//  754  * NAME: TMR_EnableTimer
//  755  * DESCRIPTION: Enable the specified timer
//  756  * PARAMETERS:  IN: tmrID - the timer ID
//  757  * RETURN: None
//  758  * NOTES: none
//  759  *****************************************************************************/

        SECTION `.text`:CODE:NOROOT(1)
        THUMB
//  760 void TMR_EnableTimer
//  761 (
//  762     tmrTimerID_t tmrID
//  763 )
//  764 {    		
TMR_EnableTimer:
        PUSH     {R4,LR}
        MOVS     R4,R0
//  765     //unsigned int saveInt;
//  766     
//  767     if (TMR_GetTimerStatus(tmrID) == mTmrStatusInactive_c)
        MOVS     R0,R4
        UXTB     R0,R0
        BL       TMR_GetTimerStatus
        CMP      R0,#+128
        BNE      ??TMR_EnableTimer_0
//  768     {      
//  769         IncrementActiveTimerNumber(TMR_GetTimerType(tmrID));    
        LDR      R0,??DataTable15_2
        LDRB     R0,[R0, #+0]
        ADDS     R0,R0,#+1
        LDR      R1,??DataTable15_2
        STRB     R0,[R1, #+0]
//  770         TMR_SetTimerStatus(tmrID, mTmrStatusReady_c);
        MOVS     R1,#+64
        MOVS     R0,R4
        UXTB     R0,R0
        BL       TMR_SetTimerStatus
//  771         TMR_Task();
        BL       TMR_Task
//  772     }  	
//  773 
//  774 }
??TMR_EnableTimer_0:
        POP      {R4,PC}          ;; return

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable15:
        DC32     maTmrTimerTable

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable15_1:
        DC32     0xea60

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable15_2:
        DC32     numberOfActiveTimers

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable15_3:
        DC32     0x40038004

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable15_4:
        DC32     previousTimeInTicks

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable15_5:
        DC32     mMaxToCountDown_c

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable15_6:
        DC32     mTicksFor4ms

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable15_7:
        DC32     0x40038010

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable15_8:
        DC32     0x40038000

        SECTION `.text`:CODE:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
??DataTable15_9:
        DC32     timerHardwareIsRunning

        SECTION `.iar_vfe_header`:DATA:NOALLOC:NOROOT(2)
        SECTION_TYPE SHT_PROGBITS, 0
        DATA
        DC32 0

        SECTION __DLIB_PERTHREAD:DATA:REORDER:NOROOT(0)
        SECTION_TYPE SHT_PROGBITS, 0

        SECTION __DLIB_PERTHREAD_init:DATA:REORDER:NOROOT(0)
        SECTION_TYPE SHT_PROGBITS, 0

        END
//  775 
//  776 
//  777 
//  778 /*****************************************************************************/
// 
//    50 bytes in section .bss
//     4 bytes in section .data
// 1 170 bytes in section .text
// 
// 1 170 bytes of CODE memory
//    54 bytes of DATA memory
//
//Errors: none
//Warnings: none
